/* ***************************************************************************+
 * ITX package (cnrg.itx) for telephony application programming.              *
 * Copyright (c) 1999  Cornell University, Ithaca NY.                         *
 * A copy of the license is distributed with this package.  Look in the docs  *
 * directory, filename GPL.  Contact information: bergmark@cs.cornell.edu     *
 ******************************************************************************/

package cnrg.itx.signal.SignalEvent;

import cnrg.itx.datax.*;
import cnrg.itx.signal.*;
import cnrg.itx.ds.*;

import java.net.*;

/** This class represents an event generated when an invitation to start a call is received.
 */
public class InviteSignalEvent extends SignalEvent
{
	/**  Connection object provided by the application  **/
	private Connection myDestConn = null;
		
	/** Default Constructor
	 * 
	 * @param ip is the InvitePacket received from the peer
	 */
	public InviteSignalEvent (InvitePacket ip){
		super(ip);
	}
	
	/**
	 * Applications call this method to indicate that they accept the invitation.
	 * The application also provides a connection that the peer should use.
	 * 
	 * @param   c is a Connection initialized by the application.
	 * @return  void
	 */	
	public void accept(Connection c){
		myDestConn = c;
		myInviteInfo.accept();		
	}

	/**
	 * Applications call this method to indicate that they accept the invitation.
	 * 
	 * @param   None
	 * @return  void
	 */	
	public void accept(){
		myInviteInfo.accept();		
	}

	/**
	 * Applications call this method to indicate that they reject the invitation.
	 * 
	 * @param   reason is the reason the application rejected the call.
	 * @return  void
	 */	
	public void reject(String reason){
		myInviteInfo.reject(reason);
	}
	
	/**
	 * Applications call this method to indicate that they are busy at present.
	 * 
	 * @param   None
	 * @return  void
	 */	
	public void busy(){
		myInviteInfo.busy();
	}
			
	/** Sets the PropertiesCollection for the callee application so that the properties
	 * can be sent to the caller application
	 * 
	 * @param pc is the PropertiesCollection of the callee application
	 */
	public void setPropertiesCollection(PropertiesCollection pc){
		myInviteInfo.setPropertiesCollection(pc);
	}

	/**
	 * @return  the PropertiesCollection of the peer
	 */	
	public PropertiesCollection getPropertiesCollection(){
		return myInviteInfo.getPropertiesCollection();
	}
		
	/**
	 * @return  the Connection object provided by the peer
	 */	
	public Connection getConnection(){
		return myDestConn;
	}	
	
	/**
	 * @return TRUE if the call was accepted, FALSE otherwise
	 */	 
	public boolean wasAccepted(){
		return myInviteInfo.wasAccepted();
	}
}
